/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWRulePanel;
import filenet.vw.toolkit.design.property.workflow.VWWFDeadlinePanel;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWAdvancedTabPanel
extends JPanel
implements DocumentListener,
ActionListener,
IVWCoordinationEventListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private JComboBox m_rosterComboBox = null;
    private JComboBox m_logComboBox = null;
    private JTextField m_waitForConditionTextField = null;
    private JButton m_expressionBuilderButton = null;
    private VWWFDeadlinePanel m_deadlinePanel = null;
    private JCheckBox m_enableEmailNotification = null;
    private JCheckBox m_transferFlagCheckBox = null;
    private JCheckBox m_validateFlagCheckBox = null;
    private VWRulePanel m_rulePanel = null;
    private VWLabelListCellRenderer m_customComboBoxRenderer = new VWLabelListCellRenderer();

    VWAdvancedTabPanel() {
    }

    public void changedUpdate(DocumentEvent event) {
        this.updateWaitForConditionExpression(event);
    }

    public void insertUpdate(DocumentEvent event) {
        this.updateWaitForConditionExpression(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.updateWaitForConditionExpression(event);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            VWWorkflowDefinition wfDefinition;
            if (this.m_authPropertyData != null && (wfDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null) {
                Object src = event.getSource();
                if (src.equals(this.m_rosterComboBox)) {
                    String rosterName = this.m_rosterComboBox.getSelectedItem().toString();
                    wfDefinition.setRosterName(rosterName);
                    String toolTipText = null;
                    VWRosterDefinition rosterDef = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getRosterDefinition(rosterName);
                    if (rosterDef != null && rosterDef.getDescription() != null) {
                        toolTipText = VWStringUtils.formatToolTip(rosterDef.getDescription(), 0);
                    }
                    this.m_rosterComboBox.setToolTipText(toolTipText);
                    this.m_authPropertyData.setDirty();
                } else if (src.equals(this.m_logComboBox)) {
                    String logName = this.m_logComboBox.getSelectedItem().toString();
                    wfDefinition.setEventLogName(logName);
                    String toolTipText = null;
                    VWLogDefinition eventLogDef = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getEventLogDefinition(logName);
                    if (eventLogDef != null && eventLogDef.getDescription() != null) {
                        toolTipText = VWStringUtils.formatToolTip(eventLogDef.getDescription(), 0);
                    }
                    this.m_logComboBox.setToolTipText(toolTipText);
                    this.m_authPropertyData.setDirty();
                } else if (src.equals(this.m_expressionBuilderButton)) {
                    VWExpressionBuilderDialog expressionBuilderDlg = new VWExpressionBuilderDialog(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData, null, this.m_waitForConditionTextField.getText(), 2703);
                    expressionBuilderDlg.init();
                    expressionBuilderDlg.setVisible(true);
                    if (expressionBuilderDlg.getDialogResult() == 0) {
                        this.m_waitForConditionTextField.setText(expressionBuilderDlg.getExpressionString());
                    }
                } else if (src.equals(this.m_enableEmailNotification)) {
                    boolean bEnable = this.m_enableEmailNotification.isSelected();
                    wfDefinition.setDisableEmailNotification(!bEnable);
                    this.m_authPropertyData.setDirty();
                } else if (src.equals(this.m_transferFlagCheckBox)) {
                    boolean bSelected = this.m_transferFlagCheckBox.isSelected();
                    wfDefinition.setTransferFlag(bSelected);
                    this.m_authPropertyData.setDirty();
                    if (bSelected) {
                        wfDefinition.setValidateFlag(true);
                        this.m_validateFlagCheckBox.setSelected(true);
                    }
                    this.m_validateFlagCheckBox.setEnabled(!bSelected);
                    this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 710, event.paramString());
                } else if (src.equals(this.m_validateFlagCheckBox)) {
                    boolean bSelected = this.m_validateFlagCheckBox.isSelected();
                    wfDefinition.setValidateFlag(bSelected);
                    this.m_authPropertyData.setDirty();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 757: 
            case 775: 
            case 777: 
            case 780: 
            case 782: {
                this.reinitialize();
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 15);
            this.add((Component)this.getLeftPanel(), gbCons);
            if (this.m_authPropertyData.getAreRulesEnabled()) {
                ++gbCons.gridx;
                gbCons.fill = 2;
                gbCons.weightx = 0.1;
                gbCons.weighty = 0.0;
                gbCons.gridheight = 1;
                gbCons.insets = new Insets(7, 5, 5, 15);
                this.m_deadlinePanel = new VWWFDeadlinePanel();
                this.m_deadlinePanel.init(this.m_authPropertyData);
                this.add((Component)this.m_deadlinePanel, gbCons);
                ++gbCons.gridy;
                gbCons.insets = new Insets(5, 5, 5, 15);
                this.add((Component)this.getWorkflowFlagsPanel(), gbCons);
                ++gbCons.gridx;
                gbCons.gridy = 0;
                gbCons.fill = 1;
                gbCons.weightx = 0.5;
                gbCons.weighty = 1.0;
                gbCons.gridheight = 0;
                gbCons.insets = new Insets(7, 5, 5, 5);
                this.m_rulePanel = new VWRulePanel(authPropertyData);
                this.add((Component)this.m_rulePanel, gbCons);
            } else {
                ++gbCons.gridx;
                gbCons.fill = 1;
                gbCons.weightx = 0.1;
                gbCons.insets = new Insets(7, 5, 5, 15);
                this.add((Component)this.getWorkflowFlagsPanel(), gbCons);
                ++gbCons.gridx;
                gbCons.insets = new Insets(7, 5, 5, 5);
                this.m_deadlinePanel = new VWWFDeadlinePanel();
                this.m_deadlinePanel.init(this.m_authPropertyData);
                this.add((Component)this.m_deadlinePanel, gbCons);
            }
            this.reinitialize();
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            this.m_waitForConditionTextField.getDocument().removeDocumentListener(this);
            this.m_rosterComboBox.removeActionListener(this);
            this.m_logComboBox.removeActionListener(this);
            this.m_enableEmailNotification.removeActionListener(this);
            this.m_transferFlagCheckBox.removeActionListener(this);
            this.m_validateFlagCheckBox.removeActionListener(this);
            this.m_waitForConditionTextField.setText("");
            this.m_rosterComboBox.removeAllItems();
            this.m_logComboBox.removeAllItems();
            this.m_enableEmailNotification.setSelected(true);
            this.m_transferFlagCheckBox.setSelected(true);
            this.m_validateFlagCheckBox.setSelected(true);
            if (this.m_authPropertyData != null) {
                VWWorkflowDefinition workflowDefinition;
                String[] rosters = null;
                String[] logs = null;
                VWDataDictionary dataDictionary = this.m_authPropertyData.getDesignerCoreData().getDataDictionary();
                if (dataDictionary != null) {
                    int logCount;
                    int i;
                    int rosterCount;
                    rosters = dataDictionary.getRosterNames();
                    if (rosters != null && (rosterCount = rosters.length) > 0) {
                        for (i = 0; i < rosterCount; ++i) {
                            this.m_rosterComboBox.addItem(rosters[i]);
                        }
                    }
                    if ((logs = dataDictionary.getEventLogNames()) != null && (logCount = logs.length) > 0) {
                        for (i = 0; i < logCount; ++i) {
                            this.m_logComboBox.addItem(logs[i]);
                        }
                    }
                }
                if ((workflowDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null) {
                    String incomingAttFolder;
                    String toolTipText;
                    this.m_waitForConditionTextField.setText(workflowDefinition.getTag());
                    if (rosters != null) {
                        VWRosterDefinition rosterDef;
                        String rosterName = workflowDefinition.getRosterName();
                        if (rosterName != null) {
                            if (this.findRoster(rosterName)) {
                                this.m_rosterComboBox.setSelectedItem(rosterName);
                            } else {
                                this.m_rosterComboBox.addItem(rosterName);
                                this.m_rosterComboBox.setSelectedItem(rosterName);
                            }
                        } else {
                            rosterName = "DefaultRoster";
                            this.m_rosterComboBox.setSelectedItem("DefaultRoster");
                        }
                        toolTipText = null;
                        if (dataDictionary != null && (rosterDef = dataDictionary.getRosterDefinition(rosterName)) != null && rosterDef.getDescription() != null) {
                            toolTipText = VWStringUtils.formatToolTip(rosterDef.getDescription(), 0);
                        }
                        this.m_rosterComboBox.setToolTipText(toolTipText);
                    }
                    if (logs != null) {
                        VWLogDefinition eventLogDef;
                        String logName = workflowDefinition.getEventLogName();
                        if (logName != null) {
                            if (this.findEventLog(logName)) {
                                this.m_logComboBox.setSelectedItem(logName);
                            } else {
                                this.m_logComboBox.addItem(logName);
                                this.m_logComboBox.setSelectedItem(logName);
                            }
                        } else {
                            logName = "DefaultEventLog";
                            this.m_logComboBox.setSelectedItem("DefaultEventLog");
                        }
                        toolTipText = null;
                        if (dataDictionary != null && (eventLogDef = dataDictionary.getEventLogDefinition(logName)) != null && eventLogDef.getDescription() != null) {
                            toolTipText = VWStringUtils.formatToolTip(eventLogDef.getDescription(), 0);
                        }
                        this.m_logComboBox.setToolTipText(toolTipText);
                    }
                    if ((incomingAttFolder = workflowDefinition.getIncomingWSAttachmentFolder()) != null && incomingAttFolder.length() > 0) {
                        try {
                            VWAttachment vwAtt = new VWAttachment(incomingAttFolder);
                            if (vwAtt != null) {
                                incomingAttFolder = vwAtt.getAttachmentName();
                            }
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                    }
                    this.m_enableEmailNotification.setSelected(!workflowDefinition.getDisableEmailNotification());
                    boolean bEnableTransfer = true;
                    VWWorkflowDefinition mainWflDef = this.m_authPropertyData.getWorkflowCollectionDefinition().getMainWorkflow();
                    if (mainWflDef != null && VWStringUtils.compare(mainWflDef.getName(), workflowDefinition.getName()) == 0) {
                        workflowDefinition.setTransferFlag(true);
                        bEnableTransfer = false;
                    }
                    this.m_transferFlagCheckBox.setSelected(workflowDefinition.getTransferFlag());
                    this.m_transferFlagCheckBox.setEnabled(bEnableTransfer);
                    if (workflowDefinition.getTransferFlag()) {
                        workflowDefinition.setValidateFlag(true);
                    }
                    this.m_validateFlagCheckBox.setSelected(workflowDefinition.getValidateFlag());
                    this.m_validateFlagCheckBox.setEnabled(!workflowDefinition.getTransferFlag());
                }
            }
            this.m_waitForConditionTextField.getDocument().addDocumentListener(this);
            this.m_rosterComboBox.addActionListener(this);
            this.m_logComboBox.addActionListener(this);
            this.m_enableEmailNotification.addActionListener(this);
            this.m_transferFlagCheckBox.addActionListener(this);
            this.m_validateFlagCheckBox.addActionListener(this);
            if (this.m_rulePanel != null) {
                this.m_rulePanel.reinitialize();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void stopEditing() {
        if (this.m_rulePanel != null) {
            this.m_rulePanel.stopEditing();
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_rosterComboBox != null) {
            this.m_rosterComboBox.removeActionListener(this);
            this.m_rosterComboBox = null;
        }
        if (this.m_logComboBox != null) {
            this.m_logComboBox.removeActionListener(this);
            this.m_logComboBox = null;
        }
        this.m_waitForConditionTextField = null;
        if (this.m_expressionBuilderButton != null) {
            this.m_expressionBuilderButton.removeActionListener(this);
            this.m_expressionBuilderButton = null;
        }
        if (this.m_deadlinePanel != null) {
            this.m_deadlinePanel.releaseReferences();
            this.m_deadlinePanel = null;
        }
        if (this.m_enableEmailNotification != null) {
            this.m_enableEmailNotification.removeActionListener(this);
            this.m_enableEmailNotification = null;
        }
        if (this.m_transferFlagCheckBox != null) {
            this.m_transferFlagCheckBox.removeActionListener(this);
            this.m_transferFlagCheckBox = null;
        }
        if (this.m_validateFlagCheckBox != null) {
            this.m_validateFlagCheckBox.removeActionListener(this);
            this.m_validateFlagCheckBox = null;
        }
        this.m_rulePanel = null;
        this.m_authPropertyData = null;
    }

    private JPanel getLeftPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.getRosterControlPanel(), gbCons);
            ++gbCons.gridy;
            panel.add((Component)this.getLogControlPanel(), gbCons);
            ++gbCons.gridy;
            panel.add((Component)this.getWaitForConditionControlPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            panel.add((Component)new JLabel(" "), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getRosterControlPanel() {
        try {
            VWToolbarBorder rosterBorder = new VWToolbarBorder(VWResource.s_roster, 0x40000000);
            JPanel panel = rosterBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_rosterComboBox = new JComboBox();
            this.m_rosterComboBox.setRenderer(this.m_customComboBoxRenderer);
            this.m_rosterComboBox.addActionListener(this);
            panel.add((Component)this.m_rosterComboBox, "Center");
            return rosterBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getLogControlPanel() {
        try {
            VWToolbarBorder logBorder = new VWToolbarBorder(VWResource.s_eventLogStr);
            JPanel panel = logBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_logComboBox = new JComboBox();
            this.m_logComboBox.setRenderer(this.m_customComboBoxRenderer);
            this.m_logComboBox.addActionListener(this);
            panel.add((Component)this.m_logComboBox, "Center");
            return logBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getWaitForConditionControlPanel() {
        try {
            VWToolbarBorder wfcBorder = new VWToolbarBorder(VWResource.s_conditionIdentifierStr);
            JPanel panel = wfcBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_waitForConditionTextField = new JTextField();
            this.m_waitForConditionTextField.getDocument().addDocumentListener(this);
            panel.add((Component)this.m_waitForConditionTextField, "Center");
            this.m_expressionBuilderButton = new JButton(VWResource.s_dots);
            this.m_expressionBuilderButton.addActionListener(this);
            panel.add((Component)this.m_expressionBuilderButton, "After");
            return wfcBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getWorkflowFlagsPanel() {
        try {
            VWToolbarBorder preferencesBorder = new VWToolbarBorder(VWResource.s_settings);
            JPanel clientPanel = preferencesBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_enableEmailNotification = new JCheckBox(VWResource.s_enableEmailNotification);
            this.m_enableEmailNotification.setName("m_enableEmailNotification_VWAdvancedTabPanel");
            this.m_enableEmailNotification.addActionListener(this);
            clientPanel.add((Component)this.m_enableEmailNotification, gbCons);
            ++gbCons.gridy;
            this.m_transferFlagCheckBox = new JCheckBox(VWResource.s_transferFlag);
            this.m_transferFlagCheckBox.setName("m_transferFlagCheckBox_VWAdvancedTabPanel");
            this.m_transferFlagCheckBox.addActionListener(this);
            clientPanel.add((Component)this.m_transferFlagCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_validateFlagCheckBox = new JCheckBox(VWResource.s_validateFlag);
            this.m_validateFlagCheckBox.setName("m_validateFlagCheckBox_VWAdvancedTabPanel");
            this.m_validateFlagCheckBox.addActionListener(this);
            clientPanel.add((Component)this.m_validateFlagCheckBox, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 0.1;
            gbCons.weighty = 1.0;
            clientPanel.add((Component)new JLabel(" "), gbCons);
            return preferencesBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateWaitForConditionExpression(DocumentEvent e) {
        VWWorkflowDefinition workflowDefinition = null;
        try {
            if (this.m_authPropertyData != null && (workflowDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null && e.getDocument() == this.m_waitForConditionTextField.getDocument()) {
                workflowDefinition.setTag(this.m_waitForConditionTextField.getText());
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean findRoster(String rosterName) {
        ComboBoxModel model;
        int size;
        boolean result = false;
        if (this.m_rosterComboBox != null && (size = (model = this.m_rosterComboBox.getModel()).getSize()) > 0) {
            for (int i = 0; i < size; ++i) {
                String name = (String)model.getElementAt(i);
                if (VWStringUtils.compare(name, rosterName) != 0) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean findEventLog(String logName) {
        ComboBoxModel model;
        int size;
        boolean result = false;
        if (this.m_logComboBox != null && (size = (model = this.m_logComboBox.getModel()).getSize()) > 0) {
            for (int i = 0; i < size; ++i) {
                String name = (String)model.getElementAt(i);
                if (VWStringUtils.compare(name, logName) != 0) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

